/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define PI 3.14159265359

float lerp(float a, float b, float t) {
  return a + t*(b-a);
}

void main ( void ) {
    vec2 st = gl_FragCoord.xy/iResolution.yy;
    vec3 color = vec3(0.0);
	
    vec2 pos = vec2(.5)-st*1.3;
    pos.x += (sin(iGlobalTime))*.15+.2;
    pos.y += (cos(iGlobalTime))*.15+.1;
	
    float r = sqrt(dot(pos,pos));
    float a = atan(pos.y,pos.x);
    
    float at = iGlobalTime*.5;
    at = floor(at) + clamp((sin(fract(at)*PI*.55)), 0., .999);
    a += at;
    
    float ct = 2.5;
    
    // flower
    float f = abs(cos(a*ct))*.4+.3;
    
    // sun
    float g = smoothstep(0.+fract(at),1., cos(a*ct*4.))*0.2+0.5;
    
    // blend the shapes
    f = lerp(f,g,sin(iGlobalTime));
    
    // eggyolk
    float e = smoothstep(.2*(abs(sin(at))+.5),.38*(abs(sin(at))+.5),r);
    e = clamp(smoothstep(f*.8,f+.4*abs(sin(iGlobalTime)),e),0.,1.);
    
    // outline of f
    float o = smoothstep(f,f+0.03, r );
    o -= clamp(smoothstep(f,f+0.08, r ), 0.,1.);
    
    color = vec3(1.,.9,.8)*( f+o )*.8
          + vec3(1.,.8,.2)*clamp(1.-e*r*.8, 0., 1.)*.8
          + clamp(1.-r*3.*(abs(sin(at*.5)*.5+1.)), 0.,1.)*.2;
    
    color = mix(vec3(.0,.4,.8), color, color);
    
    gl_FragColor = vec4(color, 1.0);
}
